import {
    fetchGraphById,
    fetchGraphByIdIfNeeded,
    fetchGraphsDiff,
    fetchGraphsDiffIfNeeded,
} from "./loader/graphActions";
import { getGraphParameters } from "src/selectors/graph";
import { dropAllNotifications } from "../../utils/notifications/notificationsState";

export function clickSearchButton() {
    return (dispatch, getState) => {
        dispatch(fetchGraphById(getGraphParameters(getState())));
    };
}

export function clickSearchDiffButton() {
    return (dispatch, getState) => {
        dispatch(fetchGraphsDiff(getGraphParameters(getState())));
    };
}

export function fetchGraph() {
    return (dispatch, getState) => {
        let parameters = getGraphParameters(getState());
        dispatch(dropAllNotifications());
        if (parameters.showDiff) {
            dispatch(fetchGraphsDiffIfNeeded(parameters));
        } else {
            dispatch(fetchGraphByIdIfNeeded(parameters));
        }
    };
}
