import {
    INVALIDATE_GRAPH_EXPORT,
    INVALIDATE_DIFF_EXPORT,
    REQUEST_GRAPH_EXPORT,
    RECEIVE_GRAPH_EXPORT,
    REQUEST_DIFF_EXPORT,
    RECEIVE_DIFF_EXPORT,
} from "./graphExportActions";

const INITIAL_STATE = {
    graph: { isFetching: false, content: "" },
    graphsDiff: { isFetching: false, content: "" },
};

export function graphExport(state = INITIAL_STATE, action) {
    switch (action.type) {
        case REQUEST_GRAPH_EXPORT:
            let fetchingGraph = Object.assign({}, state.graph);
            fetchingGraph.isFetching = true;
            return Object.assign({}, state, {
                graph: fetchingGraph,
            });
        case RECEIVE_GRAPH_EXPORT:
            let graphState = Object.assign({}, state.graph);
            graphState.isFetching = false;
            graphState.content = action.dot;
            return Object.assign({}, state, {
                graph: graphState,
            });
        case INVALIDATE_GRAPH_EXPORT:
            return Object.assign({}, state, {
                graph: INITIAL_STATE.graph,
            });
        case REQUEST_DIFF_EXPORT:
            let fetchingDiff = Object.assign({}, state.graphsDiff);
            fetchingDiff.isFetching = true;
            return Object.assign({}, state, {
                graphsDiff: fetchingDiff,
            });
        case RECEIVE_DIFF_EXPORT:
            let diffState = Object.assign({}, state.graphsDiff);
            diffState.isFetching = false;
            diffState.content = action.dot;
            return Object.assign({}, state, {
                graphsDiff: diffState,
            });
        case INVALIDATE_DIFF_EXPORT:
            return Object.assign({}, state, {
                graphsDiff: INITIAL_STATE.graphsDiff,
            });
        default:
            return state;
    }
}
