import _ from "lodash";
import * as d3 from "d3";

export function getIdTypeActivityCharts(edgesByCryptaId) {
    let maps = getIdTypeActivityMaps(edgesByCryptaId);
    return toChartData(maps);
}

function getIdTypeActivityMaps(edges) {
    // cryptaId -> activityMap
    let activityMaps = [];
    _(edges)
        .groupBy("cryptaId")
        .forEach((cryptaIdEdges, cryptaId) => {
            // id_type -> date -> ids
            let activityMap = new Map();
            let allDates = new Set();

            cryptaIdEdges.forEach((edge) => {
                edge.dates.forEach((date) => {
                    allDates.add(date);

                    [
                        [edge.id1, edge.id1Type],
                        [edge.id2, edge.id2Type],
                    ].forEach(([id, idType]) => {
                        if (!activityMap.has(idType)) {
                            activityMap.set(idType, new Map());
                        }
                        let dateIds = activityMap.get(idType);

                        if (!dateIds.has(date)) {
                            dateIds.set(date, new Set());
                        }
                        dateIds.get(date).add(id);
                    });
                });
            });

            activityMaps.push({
                cryptaId: cryptaId,
                data: activityMap,
                allDates: [...allDates],
            });
        });
    return activityMaps;
}

function toChartData(activityMaps) {
    let multiCharts = [];
    for (const activityMap of activityMaps) {
        let xAxis = activityMap.allDates.sort();

        let allSeries = [];
        for (const [idType, dates] of activityMap.data) {
            let seriesData = [];
            for (const timelineDate of xAxis) {
                if (dates.has(timelineDate)) {
                    let idsCount = dates.get(timelineDate).size;
                    seriesData.push(idsCount);
                } else {
                    seriesData.push(null);
                }
            }

            allSeries.push({
                name: idType,
                data: seriesData,
            });
        }

        multiCharts.push({
            title: {
                text: "Crypta ID activity " + activityMap.cryptaId,
            },
            chart: {
                type: "area",
            },
            series: allSeries,
            plotOptions: {
                area: {
                    stacking: "normal",
                },
            },
            xAxis: {
                categories: xAxis,
            },
            colors: d3.schemeCategory10,
        });
    }

    return multiCharts;
}
