import { handleActions } from "redux-actions";
import { invalidateGraph, requestGraph, receiveGraph, failGraph } from "./graphActions";

export const graph = handleActions(
    {
        [invalidateGraph]: (state, { payload }) => {
            return {
                ...state,
                isDiffGraph: payload.isDiffGraph,
                didFetch: false,
                isFetching: false,
            };
        },
        [requestGraph]: (state, { payload }) => {
            return {
                ...state,
                isDiffGraph: payload.isDiffGraph,
                isFetching: true,
                didFetch: false,
                vertices: [],
                edges: [],
            };
        },
        [receiveGraph]: (state, { payload }) => {
            return {
                ...state,
                isDiffGraph: payload.isDiffGraph,
                isFetching: false,
                didFetch: true,
                vertices: payload.vertices,
                edges: payload.edges,
            };
        },
        [failGraph]: (state) => ({
            ...state,
            error: true,
            isFetching: false,
            didFetch: false,
            vertices: [],
            edges: [],
        }),
    },
    {
        isFetching: false,
        didFetch: false,
        didInvalidate: false,
        isDiffGraph: false,
        vertices: [],
        edges: [],
    }
);
