import { handleActions } from "redux-actions";
import { changeSearchParams, hideDiffPanel, showDiffPanel } from "./actions";
import { DEFAULT_MATCHING_SCOPE, DEFAULT_MATCHING_TYPE, DEFAULT_GRAPH_DEPTH } from "../../utils/apiClient";

export const searchPanel = handleActions(
    {
        [changeSearchParams]: (state, { payload }) => {
            return {
                ...state,
                ...payload,
            };
        },
        [showDiffPanel]: (state) => {
            return {
                ...state,
                showDiff: true,
            };
        },
        [hideDiffPanel]: (state) => {
            return {
                ...state,
                showDiff: false,
            };
        },
    },
    {
        idValue: "",
        idType: "",
        matchType: DEFAULT_MATCHING_TYPE,
        matchScope: DEFAULT_MATCHING_SCOPE,
        depth: DEFAULT_GRAPH_DEPTH,
        idValue2: "",
        idType2: "",
        matchType2: DEFAULT_MATCHING_TYPE,
        matchScope2: DEFAULT_MATCHING_SCOPE,
        depth2: DEFAULT_GRAPH_DEPTH,
        showDiff: false,
    }
);
