import { getGraphSettings } from "../../../utils/apiClient";
import { createAction } from "redux-actions";

export const requestSettings = createAction("graph settings requested");
export const receiveSettings = createAction("graph settings received");

export function initGraphSettings() {
    return (dispatch) => {
        dispatch(requestSettings());
        return getGraphSettings().then((graphSettings) => dispatch(receiveSettings(graphSettings)));
    };
}
