import { createAction } from "redux-actions";
import { fetchAdditionalIdInfo } from "src/graph/info/actions";

export const selectId = createAction("id selected");
export const selectEdge = createAction("edge selected");
export const unselectIdAndEdge = createAction("id and edge unselected");

export const selectCryptaId = createAction("cryptaId selected");
export const resetCryptaIdSelection = createAction("cryptaId unselected");

export function selectIdAndInfo(selectedId) {
    return function (dispatch) {
        dispatch(selectId(selectedId));
        dispatch(fetchAdditionalIdInfo(selectedId));
    };
}
