import { handleActions } from "redux-actions";
import { selectId, selectEdge, selectCryptaId, unselectIdAndEdge, resetCryptaIdSelection } from "./selectActions";

export const COMPONENT_INFO_MODE = "component";
export const ID_INFO_MODE = "id";
export const EDGE_INFO_MODE = "edge";

export const selectReducer = handleActions(
    {
        [selectId]: (state, { payload }) => {
            return {
                ...state,
                selectedId: payload,
                selectedEdge: "",
                infoPanelMode: ID_INFO_MODE,
            };
        },
        [selectEdge]: (state, { payload }) => {
            return {
                ...state,
                selectedId: "",
                selectedEdge: payload,
                infoPanelMode: EDGE_INFO_MODE,
            };
        },
        [unselectIdAndEdge]: (state) => {
            return {
                ...state,
                selectedId: "",
                selectedEdge: "",
                infoPanelMode: COMPONENT_INFO_MODE,
            };
        },
        [selectCryptaId]: (state, { payload }) => {
            return {
                ...state,
                selectedCryptaId: payload,
                infoPanelMode: COMPONENT_INFO_MODE,
            };
        },
        [resetCryptaIdSelection]: (state) => {
            return {
                ...state,
                selectedCryptaId: "",
                infoPanelMode: undefined,
            };
        },
    },
    {
        selectedId: "",
        selectedEdge: "",
        selectedCryptaId: "",
        infoPanelMode: undefined,
    }
);
