import { handleActions } from "redux-actions";
import { toggleTimelineChart } from "src/graph/timelineActions";
import { invalidateGraph, receiveGraph, requestGraph } from "src/graph/search/loader/graphActions";

export const timeline = handleActions(
    {
        [toggleTimelineChart]: (state) => {
            return {
                ...state,
                timelineChartToggled: !state.timelineChartToggled,
            };
        },
        [receiveGraph]: (state, { payload }) => {
            return {
                ...state,
                chartData: payload.activityChartData,
                hasActivityData: payload.hasActivityData,
            };
        },
        [requestGraph]: (state) => {
            return {
                ...state,
                chartData: {},
                hasActivityData: false,
            };
        },
        [invalidateGraph]: (state) => {
            return {
                ...state,
                chartData: {},
                hasActivityData: false,
            };
        },
    },
    {
        timelineChartToggled: false,
        hasActivityData: false,
        chartData: {},
    }
);
