export class BaseGraphStyler {
    get name() {
        throw "you should override name() property of BaseGraphStyler";
    }

    static colorEdge(link, colorFunc) {
        link.select("path").style("stroke", colorFunc);

        link.select("text").attr("fill", colorFunc);
    }

    static colorVertex(node, colorFunc) {
        node.select("circle").attr("fill", colorFunc);

        node.select("text").attr("fill", colorFunc);
    }

    defaultEdge(link) {
        link.select("path").style("fill", "none").style("stroke-width", "2px").style("stroke", "#000080");

        link.select("text")
            .attr("opacity", 0)

            .attr("fill", "#000080");
    }

    highlightEdge(link) {
        link.select("text").attr("opacity", 1);
    }

    unhighlightEdge(link) {
        link.select("text").attr("opacity", 0);
    }

    hoverEdge(link) {
        link.select("text").attr("opacity", 1);
    }

    unhoverEdge(link) {
        link.select("text").attr("opacity", 0);
    }

    defaultVertex(node) {
        let circle = node.select("circle");

        function scalingFactor(d) {
            return Math.round(Math.sqrt(Math.sqrt(d.degree)));
        }

        let defaultCircleSize = 5;
        let defaultFontSize = 14;
        let defaultTextShift = (defaultFontSize + defaultCircleSize) / 2;

        circle
            .attr("stroke", "#333")
            .attr("stroke-width", 1.5)
            .attr("r", (d) => defaultCircleSize * scalingFactor(d))
            .attr("fill", "#000080");

        let text = node.select("text");
        text.text((d) => d.inlineGraphLabel)
            .attr("opacity", 1)
            .attr("font-size", (d) => 14 * scalingFactor(d))
            .attr("font-weight", "600")
            .attr("paint-order", "stroke")
            .attr("stroke", "white")
            .attr("stroke-width", "4px")
            .attr("stroke-linecap", "butt")
            .attr("stroke-linejoin", "miter")
            .attr("fill", "#000080")
            .attr("text-anchor", "middle")
            .attr("y", (d) => -defaultTextShift * scalingFactor(d));
    }

    highlightVertex(node) {
        node.select("text")
            .text((d) => d.inlineGraphLabel)
            .attr("opacity", 1);
    }

    unhighlightVertex(node) {
        node.select("text")
            .text((d) => d.inlineGraphLabel)
            .attr("opacity", 0);
    }

    hoverVertex(node) {
        node.select("text").text((d) => d.fullId);
    }

    unhoverVertex(node) {
        node.select("text").text((d) => d.inlineGraphLabel);
    }

    layoutParams() {
        return {
            verticesStrength: -1000,
            verticesMaxDistance: 500,
            edgesDistance: 200,
            edgesStrength: 0.1,
            linkArcCoefficient: 0.8,
        };
    }
}
