import { BaseGraphStyler } from "src/graph/viewer/style/BaseGraphStyler";
import _ from "lodash";

export class ByActivityGraphStyler extends BaseGraphStyler {
    get name() {
        return "Color by edge activity";
    }

    defaultEdge(link) {
        super.defaultEdge(link);

        BaseGraphStyler.colorEdge(link, (data) => {
            if (data.dates.length) {
                let date = new Date();
                date.setMonth(date.getMonth() - 1);
                let dateStr = date.toISOString().slice(0, 10);

                // has activity in the latest 30 days
                if (_.max(data.dates) > dateStr) {
                    return "green";
                } else {
                    return "red";
                }
            } else {
                return "blue";
            }
        });
    }

    defaultVertex(node) {
        super.defaultVertex(node);
        BaseGraphStyler.colorVertex(node, () => "black");
    }
}
