import * as d3 from "d3";
import { BaseGraphStyler } from "src/graph/viewer/style/BaseGraphStyler";

let colorScale = d3.scaleOrdinal(d3.schemeCategory10);

export class ByCryptaIdGraphStyler extends BaseGraphStyler {
    get name() {
        return "Color by cryptaId";
    }

    defaultEdge(link) {
        super.defaultEdge(link);

        BaseGraphStyler.colorEdge(link, (data) => {
            if (data.cryptaId) {
                return colorScale(data.cryptaId);
            } else {
                return "grey";
            }
        });
    }

    defaultVertex(node) {
        super.defaultVertex(node);
        BaseGraphStyler.colorVertex(node, (data) => colorScale[data.cryptaId]);
    }

    colorEdgeDefault(link) {
        const getEdgeColor = (edge) => {
            if (edge.cryptaId) {
                return this.color(edge.cryptaId);
            } else {
                return "grey";
            }
        };

        let path = link.select("path");
        path.attr("style", (d) => `fill: none; stroke-width: 2px; stroke: ${getEdgeColor(d)}`);

        let text = link.select("text");
        text.attr("fill", (d) => getEdgeColor(d));
    }

    colorEdgeHover(link) {}

    colorVertexHover(node) {
        let circle = node.select("circle");
        circle.attr("fill", (d) => this.color(d.cryptaId));

        let text = node.select("text");
        text.attr("paint-order", "stroke")
            .attr("stroke", "white")
            .attr("stroke-width", "4px")
            .attr("stroke-linecap", "butt")
            .attr("stroke-linejoin", "miter")
            .attr("fill", (d) => this.color(d.cryptaId));
    }

    colorVertexDefault(node) {
        let circle = node.select("circle");
        circle.attr("fill", (d) => this.color(d.cryptaId));

        let text = node.select("text");
        text.attr("paint-order", "stroke")
            .attr("stroke", "white")
            .attr("stroke-width", "4px")
            .attr("stroke-linecap", "butt")
            .attr("stroke-linejoin", "miter")
            .attr("fill", (d) => this.color(d.cryptaId));
    }
}
