import * as d3 from "d3";
import { statusColors } from "./diffColorMap";
import { BaseGraphStyler } from "src/graph/viewer/style/BaseGraphStyler";

let colorScale = d3.scaleOrdinal(d3.schemeCategory10);

export class ByDiffGraphStyler extends BaseGraphStyler {
    get name() {
        return "Color by diff";
    }

    defaultEdge(link) {
        super.defaultEdge(link);
        BaseGraphStyler.colorEdge(link, (data) => statusColors[data.status]);
    }

    hoverEdge(link) {
        super.hoverEdge(link);
        BaseGraphStyler.colorEdge(link, (data) => colorScale(data.sourceType + "_" + data.logSource));
    }

    unhoverEdge(link) {
        super.unhoverEdge(link);
        BaseGraphStyler.colorEdge(link, (data) => statusColors[data.status]);
    }

    defaultVertex(node) {
        super.defaultVertex(node);
        BaseGraphStyler.colorVertex(node, (data) => statusColors[data.status]);
    }

    hoverVertex(node) {
        super.hoverVertex(node);
        BaseGraphStyler.colorVertex(node, (data) => colorScale(data.idType));
    }

    unhoverVertex(node) {
        super.unhoverVertex(node);
        BaseGraphStyler.colorVertex(node, (data) => statusColors[data.status]);
    }
}
