import _ from "lodash";
import { BaseGraphStyler } from "src/graph/viewer/style/BaseGraphStyler";

export class ByIndeviceScopeGraphStyler extends BaseGraphStyler {
    get name() {
        return "Color by indevice";
    }

    defaultEdge(link) {
        super.defaultEdge(link);

        BaseGraphStyler.colorEdge(link, (data) => {
            if (_.includes(data.attributes, "indevice")) {
                return "#fede33";  // Banana Yellow
            } else {
                return data.props.indevice ? "#91c028"  // Dark Lemon Lime
                                           : "#fa0d1c"; // Vivid Red
            }
        });
    }

    defaultVertex(node) {
        super.defaultVertex(node);
        BaseGraphStyler.colorVertex(node, () => "#173dea");  // Palatinate Blue
    }
}
