import * as d3 from "d3";
import { BaseGraphStyler } from "src/graph/viewer/style/BaseGraphStyler";

let colorScale = d3.scaleOrdinal(d3.schemeCategory10);

export class BySourceGraphStyler extends BaseGraphStyler {
    get name() {
        return "Color by source type";
    }

    defaultEdge(link) {
        super.defaultEdge(link);
        BaseGraphStyler.colorEdge(link, (data) => colorScale(data.sourceType + "_" + data.logSource));
    }

    defaultVertex(node) {
        super.defaultVertex(node);
        BaseGraphStyler.colorVertex(node, (data) => colorScale(data.idType));
    }
}
