import { BaseGraphStyler } from "src/graph/viewer/style/BaseGraphStyler";

export class ByUsageScopeGraphStyler extends BaseGraphStyler {
    get name() {
        return "Color by yandex_safe";
    }

    defaultEdge(link) {
        super.defaultEdge(link);

        BaseGraphStyler.colorEdge(link, (data) => {
            return data.usage.yandexSafe ? "green" : "red";
        });
    }

    defaultVertex(node) {
        super.defaultVertex(node);
        BaseGraphStyler.colorVertex(node, () => "#000080");
    }
}
