import { BaseGraphStyler } from "src/graph/viewer/style/BaseGraphStyler";

export class SoupConfigIndeviceGraphStyler extends BaseGraphStyler {
    get name() {
        return "Color config by indevice";
    }

    defaultEdge(link) {
        super.defaultEdge(link);

        link.select("text").attr("font-size", "16px").attr("font-weight", "600").attr("opacity", 1);

        BaseGraphStyler.colorEdge(link, (data) => {
            return data.props.indevice ? "green" : "red";
        });
    }

    defaultVertex(node) {
        super.defaultVertex(node);

        node.select("text").attr("font-size", "30px");

        BaseGraphStyler.colorVertex(node, () => "#000080");
    }

    hoverEdge() {}

    unhoverEdge() {}

    layoutParams() {
        return {
            verticesStrength: -20000,
            verticesMaxDistance: 2000,
            edgesDistance: 1000,
            edgesStrength: 0.1,
            linkArcCoefficient: 1.6,
        };
    }
}
