import i18n from "i18next";
import { initReactI18next } from "react-i18next";
import Backend from "i18next-xhr-backend";

import lib_en from "@lib/i18n/en/lib.json";
import lib_ru from "@lib/i18n/ru/lib.json";
import utils_en from "./en/utils.json";
import utils_ru from "./ru/utils.json";
import profile_en from "./en/profile.json";
import profile_ru from "./ru/profile.json";
import bbprofile_en from "./en/bbprofile.json";
import bbprofile_ru from "./ru/bbprofile.json";
import common_en from "./en/common.json";
import common_ru from "./ru/common.json";

i18n.use(Backend)
    .use(initReactI18next)
    .init({
        fallbackLng: "ru",
        debug: true,
        lng: "ru",

        react: {
            useSuspense: false,
        },

        interpolation: {
            escapeValue: false, // not needed for react as it escapes by default
        },

        resources: {
            en: {
                lib: lib_en,
                utils: utils_en,
                profile: profile_en,
                bbprofile: bbprofile_en,
                common: common_en,
            },
            ru: {
                lib: lib_ru,
                utils: utils_ru,
                profile: profile_ru,
                bbprofile: bbprofile_ru,
                common: common_ru,
            },
        },
    });

export default i18n;
