import React, { Component } from "react";
import ReactDOM from "react-dom";
import App from "./App";
import { configureLego } from "@lib/components/lego";

import { createStore, applyMiddleware, compose } from "redux";
import { ConnectedRouter, routerMiddleware } from "connected-react-router";
import { Provider } from "react-redux";
import { createBrowserHistory } from "history";
import thunk from "redux-thunk";
import createRootReducer from "reducers";

import "i18n/config";

import "index.scss";
import "@lib/fonts/font-awesome.css";

configureLego();

const history = createBrowserHistory();

const middleware = [applyMiddleware(thunk), applyMiddleware(routerMiddleware(history))];

const store = compose(...middleware)(createStore)(
    createRootReducer(history),
    window.__REDUX_DEVTOOLS_EXTENSION__ && window.__REDUX_DEVTOOLS_EXTENSION__()
);

ReactDOM.render(
    <React.StrictMode>
        <Provider store={store}>
            <ConnectedRouter history={history}>
                <App />
            </ConnectedRouter>
        </Provider>
    </React.StrictMode>,
    document.getElementById("root")
);
