import React, { useState } from "react";
import { isEmpty } from "lodash";

import "./Dmp.scss";

const Dmp = (props) => {
    const profile = props.profile;

    return (
        !isEmpty(profile) && (
            <div className="Dmp">
                {profile.map((item, index) => {
                    return <DmpItem key={index} value={item} />;
                })}
            </div>
        )
    );
};

const DmpItem = (props) => {
    const item = props.value;

    const [hidden, setHidden] = useState(true);

    const valuesClassnameSuffix = hidden ? "-hidden" : "";

    const segments = item ? item.segments : [];

    return (
        <>
            <div className="Dmp-item-name" onClick={() => setHidden(!hidden)} title={`id=${item.id}`}>
                {item.name}
            </div>
            <div className={`Dmp-item-values${valuesClassnameSuffix}`}>
                {segments.map((segment, index) => {
                    let hierarchy =
                        segment.hierarchy.fallback.length > 0 ? segment.hierarchy.fallback : segment.hierarchy.ru;

                    let title = segment.title.fallback !== "" ? segment.title.fallback : segment.title.ru;

                    let margin = 0;

                    let statusStyle = segment.status === "DISABLED" ? "#999" : "#333";

                    return (
                        <div key={index} style={{ marginBottom: "10px" }} title={`id=${segment.id}`}>
                            {hierarchy.map((level, key) => {
                                margin += 20;
                                return (
                                    <div
                                        key={key}
                                        style={{
                                            marginLeft: margin + "px",
                                            color: statusStyle,
                                        }}
                                    >
                                        {level}
                                    </div>
                                );
                            })}
                            <div
                                style={{
                                    marginLeft: margin + 20 + "px",
                                    color: statusStyle,
                                }}
                            >
                                {title}
                            </div>
                        </div>
                    );
                })}
            </div>
        </>
    );
};

export default Dmp;
