import React, { useState } from "react";
import { isUndefined } from "lodash";
import Link from "@lib/components/link";
import PredictedLabel from "./PredictedLabel";

import "./InterestItem.scss";

const InterestItem = (props) => {
    const { item, weighted, labUrl } = props;

    const [descriptionHidden, setDescriptionHidden] = useState(true);

    const descriptionClassnameSuffix = descriptionHidden ? "-hidden" : "";

    return (
        !isUndefined(item.name) && (
            <div className="InterestItem">
                <div className="InterestItem-name" onClick={() => setDescriptionHidden(!descriptionHidden)}>
                    {item.name ? item.name : "-"}
                </div>
                <div className={`InterestItem-description${descriptionClassnameSuffix}`}>
                    <div className="interest-item-info">
                        {weighted ? <div>probability: {Math.round(item.weight * 100).toFixed(0)}%</div> : <div />}
                        <div>
                            <Link href={labUrl} target={"_blank"}>
                                id: {item.id}
                            </Link>
                        </div>
                        {item.timestamp ? <PredictedLabel time={item.timestamp} /> : <span />}
                        <br />
                    </div>
                    {item.description ? item.description : "-"}
                </div>
            </div>
        )
    );
};

export default InterestItem;
