import React, { Component } from "react";

import "./Loyalty.scss";
import PredictedLabel from "./PredictedLabel";

class Loyalty extends Component {
    render() {
        const profile = this.props.profile;

        if (profile) {
            return (
                <div className="loyalty-container">
                    <div className="loyalty-content">
                        {Math.round(profile.value * 100).toFixed()}% loyal to Yandex
                        <PredictedLabel time={profile.timestamp} />
                    </div>
                </div>
            );
        }

        return <div />;
    }
}

export default Loyalty;
