import React from "react";
import { useTranslation } from "react-i18next";
import moment from 'moment';
import "moment/locale/ru";

import "./PredictedLabel.scss";

function fromNow(time, t, lang) {
    moment.locale(lang);

    if (time > moment()) {
        return t("today");
    } else {
        return time.fromNow();
    }
}

const PredictedLabel = (props) => {
    const { time } = props;

    const { t, i18n } = useTranslation("profile");

    if (time) {
        const ago = moment.unix(time);
        return (
            <div className="PredictedLabel">
                {t("predicted")} {fromNow(ago, t, i18n.language)}
            </div>
        );
    }

    return <div />;
};

export default PredictedLabel;
