import React from "react";
import { isUndefined } from "lodash";
import Interests from "./Interests";

const TimedInterests = (props) => {
    const { profile, chronological } = props;

    if (profile && profile.value.length > 0) {
        profile.value.forEach((item) => {
            if (!isUndefined(item.name.ru)) {
                item.name = item.name.ru;
            }
        });

        return <Interests profile={profile} chronological={chronological} />;
    }

    return <div />;
};

export default TimedInterests;
