import React, { Component } from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";
import { fetchExperimentsDescription } from "src/me/actions";

import Link from "@lib/components/link";
import { Modal } from "@lib/components/lego";

import stPic from "../../../public/st_favicon.ico";

import "./ExperimentsDescription.scss";

class StartrekIcon extends Component {
    render() {
        return <img src={stPic} alt="ST" />;
    }
}

class DescriptionTag extends Component {
    render() {
        const { id, description, bin, issue, parameters, handleShowParameters } = this.props;

        return (
            <span className="experiment-description-tag">
                <span className="experiment-description-id">{id}</span>
                <span className="experiment-bin">Bin={bin}</span>
                <span
                    className="experiment-description-text"
                    onClick={() => handleShowParameters(parameters, description)}
                >
                    {description}
                </span>
                <span className="experiment-tracker-icon">
                    <Link href={"https://st.yandex-team.ru/" + issue} target="_blank">
                        <StartrekIcon />
                    </Link>
                </span>
            </span>
        );
    }
}

class ParametersModal extends Component {
    render() {
        const { show, content, heading, handleClose } = this.props;

        return (
            <Modal visible={show} onClose={handleClose} zIndexGroupLevel={20} theme="normal">
                <div className="ParametersModal">
                    <div className="heading">{heading}</div>
                    <pre>{JSON.stringify(content, null, 2)}</pre>
                </div>
            </Modal>
        );
    }
}

@connect(
    (state) => ({
        descriptions: state.activeExperiments.values,
        loading: state.activeExperiments.loading,
    }),
    (dispatch) => ({
        fetchDescriptions: (uid) => dispatch(fetchExperimentsDescription(uid)),
    })
)
class ExperimentsDescription extends Component {
    constructor(props) {
        super(props);
        this.handleShowParametersModal = this.handleShowParametersModal.bind(this);
        this.handleCloseParametersModal = this.handleCloseParametersModal.bind(this);

        this.state = {
            showParametersModal: false,
            parametersModalHeading: null,
            parametersModalContent: null,
        };
    }

    componentDidMount() {
        this.props.fetchDescriptions(this.props.uid);
    }

    componentDidUpdate(prevProps) {
        if (prevProps.uid !== this.props.uid) {
            this.props.fetchDescriptions(this.props.uid);
        }
    }

    handleShowParametersModal(content, heading) {
        this.setState({
            showParametersModal: true,
            parametersModalHeading: heading,
            parametersModalContent: content,
        });
    }

    handleCloseParametersModal() {
        this.setState({
            showParametersModal: false,
            parametersModalHeading: null,
            parametersModalContent: null,
        });
    }

    render() {
        const { descriptions } = this.props;

        return isEmpty(this.props.descriptions) ? (
            <div />
        ) : (
            <div>
                <div className="experiments-description-container">
                    {descriptions.map((item) => (
                        <div key={item.ExperimentID}>
                            <DescriptionTag
                                id={item.ExperimentID}
                                description={item.Description}
                                bin={item.BinID}
                                parameters={item.Parameters}
                                issue={item.Issue}
                                handleShowParameters={this.handleShowParametersModal}
                            />
                        </div>
                    ))}
                </div>
                <ParametersModal
                    show={this.state.showParametersModal}
                    heading={this.state.parametersModalHeading}
                    content={this.state.parametersModalContent}
                    handleClose={this.handleCloseParametersModal}
                />
            </div>
        );
    }
}

export default ExperimentsDescription;
