import React, { Component } from "react";
import { isEmpty } from "lodash";

import "./ExperimentsResult.scss";

export default class ExperimentsResult extends Component {
    render() {
        const { parameters, target } = this.props;

        return !isEmpty(target) ? (
            <div className="experiments-result-container">
                <div className="experiments-result">
                    {!isEmpty(parameters) ? (
                        Object.entries(parameters).map(([key, value]) => {
                            return (
                                <div key={key} className="experiments-result-item">
                                    {key} <span className="experiment-parameter-value"> → {value}</span>
                                </div>
                            );
                        })
                    ) : (
                        <div style={{ textAlign: "center", width: "100%" }}>Nothing found</div>
                    )}
                </div>
            </div>
        ) : (
            ""
        );
    }
}
