import { sortBy } from "lodash";

function matchSubstring(needle, inputString) {
    let foundAtIndex = inputString.toLowerCase().indexOf(needle.toLowerCase());
    return foundAtIndex === -1 ? false : [inputString, foundAtIndex];
}

export function searchSubstring(needle, haystack) {
    let results = [];

    haystack.forEach((inputString) => {
        let result = matchSubstring(needle, inputString);

        if (result) {
            results.push(result);
        }
    });

    return sortBy(results, (item) => item[1]).map((result) => result[0]);
}
