import React from "react";

import "./index.scss";

function Icon(props) {
    const { confidence, exact } = props;
    return (
        <svg viewBox="0 0 1000 1000">
            <g id="Layer 1">
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M10.949+499.567C10.949+230.214+229.496+11.8606+499.088+11.8606C768.679+11.8606+987.227+230.214+987.227+499.567C987.227+768.92+768.679+987.273+499.088+987.273C229.496+987.273+10.949+768.92+10.949+499.567Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M489.584+652.93C245.734+654.902+238.27+684.367+238.27+684.367L237.438+911.188C313.077+959.283+402.793+987.281+499.094+987.281C585.98+987.281+667.481+964.477+738.156+924.719L738.989+684.367C738.989+684.367+743.222+650.88+489.584+652.93Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M489.594+652.938C245.744+654.909+238.281+684.375+238.281+684.375L237.938+778.844L242.094+788.562C238.854+798.28+263.601+772.678+271.406+779.312C285.978+791.699+302.676+840.953+324+839.531C338.082+838.592+345.217+816.048+358.125+811.438C376.087+805.023+380.937+836.894+398.656+835.531C420.235+833.871+431.092+797.421+450.469+790.156C469.49+783.025+486.955+819.817+518.312+800.188C538.798+787.363+563.497+844.464+595.595+838.93C620.988+834.552+617.726+797.016+640.527+784.61C663.328+772.204+665.278+812.105+681.434+814.117C698.899+816.292+724.099+783.85+738.688+776.094L739+684.375C739+684.375+743.232+650.887+489.594+652.938Z"
                    fill="#fc0"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M241.644+687.482C241.644+687.482+244.584+721.251+494.729+718.862C744.874+716.473+742.363+687.482+742.363+687.482"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M661.421+799.724C661.421+711.251+733.555+639.53+822.536+639.53C911.517+639.53+983.65+711.251+983.65+799.724C983.65+888.197+911.517+959.919+822.536+959.919C733.555+959.919+661.421+888.197+661.421+799.724Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <text
                    x="0"
                    y="0"
                    textAnchor="middle"
                    fontSize="134"
                    fill="#000000"
                    opacity="1"
                    transform="matrix(1 0 0 1 692.645 729.095)"
                >
                    <tspan x="135.598" y="121">
                        {confidence + "%"}
                    </tspan>
                </text>
                <text
                    x="0"
                    y="0"
                    textAnchor="middle"
                    fontSize="240"
                    fill="#000000"
                    opacity="1"
                    transform="matrix(1 0 0 1 162.445 172.908)"
                >
                    <tspan x="335.191" y="217">
                        {exact}
                    </tspan>
                </text>
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M484.283+669.224L490.982+561.709L496.497+561.568L500.133+694.203C500.133+694.203+502.27+697.935+492.802+698.259C483.536+698.577+482.737+694.036+482.737+694.036L484.283+669.224"
                    fill="#000000"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M493.688+546C482.402+545.825+469.459+536.761+469.982+524.211C470.71+506.751+498.407+468.435+498.407+468.435C498.407+468.435+514.997+507.434+515.128+524.908C515.259+542.383+504.975+546.174+493.688+546Z"
                    fill="#ffd800"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M407.893+659.341L414.592+551.827L420.107+551.685L423.744+684.32C423.744+684.32+425.88+688.053+416.412+688.377C407.147+688.694+406.347+684.153+406.347+684.153L407.893+659.341"
                    fill="#000000"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M417.299+536.117C406.012+535.943+393.07+526.879+393.593+514.329C394.32+496.869+420.648+452.102+420.648+452.102C420.648+452.102+438.608+497.551+438.739+515.026C438.869+532.5+428.585+536.292+417.299+536.117Z"
                    fill="#fc0"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M562.945+658.833L569.644+551.319L575.159+551.178L578.796+683.813C578.796+683.813+580.932+687.545+571.464+687.869C562.198+688.186+561.399+683.645+561.399+683.645L562.945+658.833"
                    fill="#000000"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M572.35+535.61C561.064+535.435+548.122+526.371+548.645+513.821C549.372+496.361+570.433+458.914+570.433+458.914C570.433+458.914+593.66+497.044+593.79+514.518C593.921+531.993+583.637+535.784+572.35+535.61Z"
                    fill="#fc0"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
            </g>
        </svg>
    );
}

const AGES = {
    from0To17: "0\u201317",
    from18To24: "18\u201324",
    from25To34: "25\u201334",
    from35To44: "35\u201344",
    from45To54: "45\u201354",
    from55To99: "55+",
};

function AgeIcon(props) {
    const confidence = props.values[props.exact] || 0.0;
    return (
        <div className="AgeIcon">
            <Icon confidence={Math.round(100 * confidence)} exact={AGES[props.exact]} />
        </div>
    );
}

export default AgeIcon;
