import React from "react";

import "./index.scss";

function ManIcon(props) {
    const { confidence } = props;
    return (
        <svg viewBox="0 0 1000 1000">
            <g id="Layer 1">
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M10.949+499.567C10.949+230.214+229.496+11.8606+499.088+11.8606C768.679+11.8606+987.227+230.214+987.227+499.567C987.227+768.92+768.679+987.273+499.088+987.273C229.496+987.273+10.949+768.92+10.949+499.567Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M309.322+558.032C309.322+558.032+286.597+552.505+277.964+529.51C272.592+515.199+270.367+489.987+267.618+467.84C264.548+443.105+288.399+432.498+288.399+432.498"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M677.122+559.862C677.122+559.862+699.37+554.15+708.479+531.34C714.185+517.053+718.172+488.13+718.825+469.67C719.747+443.64+698.044+434.328+698.044+434.328"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M348.469+649.719L349.438+773.969C349.438+773.969+369.97+841.667+421.969+873.156C471.158+902.944+518.943+893.096+565.767+869.558C616.45+844.08+635.219+773.312+635.219+773.312L634.344+651.469C629.287+659.393+624.244+667.096+619.594+674.281C602.65+700.462+589.878+715.837+575.406+731.531C559.878+748.371+557.343+752.385+535+759.25C514.458+765.562+474.838+766.825+445.406+756.781C422.927+749.11+410.375+734.375+410.375+734.375C410.375+734.375+384.125+700.463+363.906+672.156C357.998+663.884+353.008+656.676+348.469+649.719Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M397.438+295.031C397.437+295.031+352.103+307.484+329.438+335.25C300.481+370.722+292.688+445.281+292.688+445.281C299.788+481.882+305.86+546.925+320.75+591.719C332.183+626.112+343.004+642.894+363.906+672.156C384.125+700.463+410.375+734.375+410.375+734.375C410.375+734.375+422.927+749.11+445.406+756.781C474.838+766.825+514.458+765.562+535+759.25C557.343+752.385+559.878+748.371+575.406+731.531C589.878+715.837+602.65+700.462+619.594+674.281C634.854+650.701+654.769+622.72+663.156+593.094C674.077+554.518+685.006+490.166+690.625+442.094C689.32+434.522+687.84+428.176+686.25+422.312C681.43+410.591+672.908+396.099+662.531+380.469C656.351+374.508+649.139+368.703+640.25+361.719C609.768+337.77+567.45+357.92+518.719+343.188C456.526+324.385+397.438+295.031+397.438+295.031Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M523.493+563.184C540.124+563.184+476.265+563.774+476.265+563.774C476.265+563.774+475.675+451.312+476.265+432.125C476.764+415.898+470.657+397.589+449.699+396.409C421.995+394.848+347.568+396.114+347.568+396.114"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M556.448+625.119C556.448+625.119+541.309+633.859+530.774+635.954C515.36+639.02+471.347+638.876+452.886+636.435C442.148+635.016+426.383+626.344+426.383+626.344"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M530.826+396.622L636.488+395.471"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M597.332+452.188L570.269+452.476"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M413.359+451.325L386.584+451.901"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M329.451+335.257C352.117+307.491+397.449+295.025+397.449+295.025C397.449+295.025+456.519+324.388+518.711+343.19C567.443+357.923+609.761+337.767+640.243+361.715C669.716+384.871+682.472+394.755+690.631+442.087C697.772+391.355+705.875+348.753+704.166+311.929C702.457+275.105+700.297+255.188+686.619+226.873C672.942+198.557+662.11+179.61+635.051+156.505C607.992+133.4+579.888+118.99+545.955+111.061C512.021+103.133+471.76+102.519+435.924+108.227C400.088+113.936+379.859+125.616+356.641+143.112C333.422+160.608+316.737+178.46+302.728+207.49C288.719+236.521+279.498+261.373+277.476+305.525C275.611+346.252+292.685+445.268+292.685+445.268C292.685+445.268+300.495+370.729+329.451+335.257Z"
                    fill="#fc0"
                    strokeLinecap="butt"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M348.688+768.344C348.688+768.344+231.56+806.125+144.5+834.562C233.48+928.547+359.389+987.281+499.094+987.281C637.43+987.281+762.207+929.688+851.031+837.312C760.991+810.902+636.969+775.812+636.969+775.812L634.438+775.75C632.516+782.554+613.774+845.437+565.781+869.562C518.958+893.1+471.158+902.944+421.969+873.156C369.97+841.667+349.438+773.969+349.438+773.969L349.406+768.375L348.688+768.344Z"
                    fill="#000000"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M661.421+799.724C661.421+711.251+733.555+639.53+822.536+639.53C911.517+639.53+983.65+711.251+983.65+799.724C983.65+888.197+911.517+959.919+822.536+959.919C733.555+959.919+661.421+888.197+661.421+799.724Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <text
                    x="0"
                    y="0"
                    textAnchor="middle"
                    fill="#000000"
                    fontSize="134"
                    opacity="1"
                    transform="matrix(1 0 0 1 692.645 729.095)"
                >
                    <tspan x="135.598" y="121">
                        {confidence + "%"}
                    </tspan>
                </text>
            </g>
        </svg>
    );
}

function WomanIcon(props) {
    const { confidence } = props;
    return (
        <svg viewBox="0 0 1000 1000">
            <g id="Layer 1">
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M10.949+499.567C10.949+230.214+229.496+11.8606+499.088+11.8606C768.679+11.8606+987.227+230.214+987.227+499.567C987.227+768.92+768.679+987.273+499.088+987.273C229.496+987.273+10.949+768.92+10.949+499.567Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M309.322+558.032C309.322+558.032+286.597+552.505+277.964+529.51C272.592+515.199+270.367+489.987+267.618+467.84C264.548+443.105+288.399+432.498+288.399+432.498"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M478.305+688.932C560.283+690.964+714.743+729.29+714.743+729.29C714.743+729.29+713.634+382.453+711.925+345.629C710.216+308.805+699.651+269.585+685.974+241.27C672.296+212.954+658.814+191.918+631.755+168.814C604.696+145.709+582.974+129.487+549.041+121.559C515.107+113.631+486.327+110.808+450.491+116.516C414.654+122.225+386.522+135.234+363.304+152.73C340.085+170.226+319.229+193.227+299.661+225.109C282.8+252.582+266.482+295.372+264.46+339.524C262.594+380.251+268.771+725.621+268.771+725.621C268.771+725.621+379.653+686.486+478.305+688.932Z"
                    fill="#fc0"
                    strokeLinecap="butt"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M309.133+350.563C309.133+350.563+307.921+400.577+312.467+449.985C317.594+505.69+314.564+508.631+335.021+572.824C355.278+636.39+409.764+698.211+409.764+698.211C409.764+698.211+446.047+742.608+486.254+742.917C531.658+743.266+554.899+707.716+570.427+690.876C584.899+675.181+625.384+615.711+633.771+586.084C644.691+547.508+655.899+509.699+660.748+456.047C664.83+410.895+666.811+350.866+666.811+350.866L309.133+350.563Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M523.493+563.184C540.124+563.184+476.265+563.774+476.265+563.774C476.265+563.774+475.675+451.312+476.265+432.125C476.764+415.898+470.657+397.589+449.699+396.409C421.995+394.848+347.568+396.114+347.568+396.114"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M548.194+626.1C548.194+626.1+527.912+635.459+517.376+637.555C501.963+640.62+484.018+638.631+465.558+636.191C454.82+634.771+433.649+626.373+433.649+626.373"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M530.826+396.622L636.488+395.471"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M604.768+451.776L566.148+451.966"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M413.359+451.325L375.52+451.966"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M373.668+764.472C373.668+764.472+231.56+800.687+144.5+829.124C233.48+923.108+359.389+981.843+499.094+981.843C637.43+981.843+762.207+924.25+851.031+831.874C760.991+805.464+608.966+760.018+608.966+760.018L496.727+951.218L486.625+950.857L373.668+764.472Z"
                    fill="#000000"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M661.421+799.724C661.421+711.251+733.555+639.53+822.536+639.53C911.517+639.53+983.65+711.251+983.65+799.724C983.65+888.197+911.517+959.919+822.536+959.919C733.555+959.919+661.421+888.197+661.421+799.724Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <text
                    x="0"
                    y="0"
                    textAnchor="middle"
                    fill="#000000"
                    fontSize="134"
                    opacity="1"
                    transform="matrix(1 0 0 1 692.645 729.095)"
                >
                    <tspan x="135.598" y="121">
                        {confidence + "%"}
                    </tspan>
                </text>
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M607.656+638.312C593.755+660.878+578.301+682.348+570.438+690.875C554.909+707.715+531.655+743.256+486.25+742.906C446.044+742.597+409.75+698.219+409.75+698.219C409.75+698.219+371.719+646.75+371.719+646.75L375.647+764.719C375.647+764.719+489.872+947.971+489.872+947.971L609.213+760.761L607.656+638.312Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M375.408+618.415"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="miter"
                />
            </g>
        </svg>
    );
}

const ExactToIcon = {
    female: (confidence) => <WomanIcon confidence={confidence} />,
    male: (confidence) => <ManIcon confidence={confidence} />,
};

function GenderIcon(props) {
    const empty = () => null;
    const icon = ExactToIcon[props.exact] || empty;
    const confidence = props.values[props.exact] || 0.0;
    return <div className="GenderIcon">{icon(Math.round(100 * confidence))}</div>;
}

export default GenderIcon;
