import React from "react";

import "./index.scss";

function Icon(props) {
    const { confidence, exact } = props;
    return (
        <svg viewBox="0 0 1000 1000">
            <g id="Layer 1">
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M10.949+499.567C10.949+230.214+229.496+11.8606+499.088+11.8606C768.679+11.8606+987.227+230.214+987.227+499.567C987.227+768.92+768.679+987.273+499.088+987.273C229.496+987.273+10.949+768.92+10.949+499.567Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M149.531+487.344L149.531+727.656C149.531+749.938+169.593+768+194.344+768L906.594+768C957.513+690.995+987.219+598.763+987.219+499.562C987.219+399.008+956.764+305.57+904.562+227.938L194.344+227.938C169.593+227.937+149.531+245.999+149.531+268.281L149.531+487.344"
                    fill="none"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M149.531+510.844L149.531+727.656C149.531+749.938+169.593+768+194.344+768L906.594+768C955.576+693.925+984.837+605.748+987+510.844L149.531+510.844Z"
                    fill="#fc0"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="40.71"
                    d="M495.156+686.964L796.243+687.238"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <path
                    stroke="#000000"
                    strokeWidth="40.71"
                    d="M220.049+688.592L409.986+687.753"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <g opacity="1">
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M215.584+624.241L215.584+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M256.273+624.241L256.273+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M296.963+624.241L296.963+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M337.652+624.241L337.652+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                </g>
                <g opacity="1">
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M419.031+624.241L419.031+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M459.72+624.241L459.72+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M500.41+624.241L500.41+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M541.099+624.241L541.099+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                </g>
                <g opacity="1">
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M622.478+624.241L622.478+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M663.167+624.241L663.167+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M703.857+624.241L703.857+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M744.546+624.241L744.546+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                </g>
                <g opacity="1">
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M825.925+624.241L825.925+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M866.614+624.241L866.614+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M907.304+624.241L907.304+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                    <path
                        stroke="#000000"
                        strokeWidth="15"
                        d="M947.993+624.241L947.993+583.552"
                        fill="#ffffff"
                        strokeLinecap="round"
                        opacity="1"
                        strokeLinejoin="round"
                    />
                </g>
                <text
                    x="0"
                    y="0"
                    textAnchor="middle"
                    fill="#000000"
                    fontSize="156"
                    opacity="1"
                    transform="matrix(1.27154 0 0 1.27154 113.86 258.037)"
                >
                    <tspan x="352" y="141">
                        {exact}
                    </tspan>
                </text>
                <path
                    stroke="#000000"
                    strokeWidth="10"
                    d="M661.421+799.724C661.421+711.251+733.555+639.53+822.536+639.53C911.517+639.53+983.65+711.251+983.65+799.724C983.65+888.197+911.517+959.919+822.536+959.919C733.555+959.919+661.421+888.197+661.421+799.724Z"
                    fill="#ffffff"
                    strokeLinecap="round"
                    opacity="1"
                    strokeLinejoin="round"
                />
                <text
                    x="0"
                    y="0"
                    textAnchor="middle"
                    fill="#000000"
                    fontSize="134"
                    opacity="1"
                    transform="matrix(1 0 0 1 692.645 729.095)"
                >
                    <tspan x="135.598" y="121">
                        {confidence + "%"}
                    </tspan>
                </text>
            </g>
        </svg>
    );
}

export const INCOMES = {
    A: "$/A",
    B1: "$$/B1",
    B2: "$$+/B2",
    C1: "$$$/C1",
    C2: "$$$+/C2",
};

function IncomeIcon(props) {
    const confidence = props.values[props.exact] || 0.0;
    return (
        <div className="IncomeIcon">
            <Icon confidence={Math.round(100 * confidence)} exact={INCOMES[props.exact]} />
        </div>
    );
}

export default IncomeIcon;
