import React, { Component } from "react";
import LoadingSpinner from "../../common/LoadingSpinner";
import { getMeProfile } from "../../utils/apiClient";
import { connect } from "react-redux";
import { getUid, getUidType } from "selectors";

import GenderIcon from "me/icon/gender";
import AgeIcon from "me/icon/age";
import IncomeIcon from "me/icon/income";

import "./MiniMe.scss";
import { COMMON_TO_BIGB_API_ID_MAP } from "src/common/Names";

@connect((state) => ({
    uid: getUid(state),
    uidType: getUidType(state),
}))
class MiniMe extends Component {
    constructor() {
        super();

        this.state = {
            loaded: false,
        };
    }

    componentDidMount() {
        getMeProfile(COMMON_TO_BIGB_API_ID_MAP[this.props.uidType], this.props.uid).then((profile) => {
            this.setState({
                gender: profile.gender,
                age: profile.age,
                income: profile.income,
                exactDemographics: profile.exactDemographics,
                loaded: true,
            });
        });
    }

    render() {
        const { gender, age, income, exactDemographics } = this.state;
        if (this.state.loaded) {
            return (
                <div className="mini-me-container">
                    <GenderIcon values={gender} exact={exactDemographics.gender} />
                    <AgeIcon values={age} exact={exactDemographics.age6} />
                    <IncomeIcon values={income} exact={exactDemographics.income5} />
                </div>
            );
        }

        return (
            <div className="mini-me-loading">
                <LoadingSpinner />
            </div>
        );
    }
}

export default MiniMe;
