import { handleActions } from "redux-actions";
import {
    receiveExperiments,
    receiveExperimentsDescription,
    receiveMe,
    receiveTransactions,
    requestExperiments,
    requestExperimentsDescription,
    requestMe,
    requestTransactions,
} from "src/me/actions";

const DEFAULT_STATE = {
    profile: {},
    loading: true,
};

export const me = handleActions(
    {
        [requestMe]: (state) => ({
            ...state,
            loading: true,
        }),
        [receiveMe]: (state, { payload }) => ({
            ...state,
            profile: payload,
            loading: false,
        }),
    },
    DEFAULT_STATE
);

const DEFAULT_EXPERIMENTS = {
    values: [],
    haystack: [],
    status: 0,
    loading: true,
};

export const experiments = handleActions(
    {
        [requestExperiments]: (state) => ({
            ...state,
            loading: true,
        }),
        [receiveExperiments]: (state, { payload }) => ({
            ...state,
            values: payload[0],
            haystack: payload[1],
            status: payload[2],
            loading: false,
        }),
    },
    DEFAULT_EXPERIMENTS
);

const DEFAULT_TRANSACTIONS = {
    values: [],
    loading: true,
};

export const transactions = handleActions(
    {
        [requestTransactions]: (state) => ({
            ...state,
            loading: true,
        }),
        [receiveTransactions]: (state, { payload }) => ({
            ...state,
            values: payload,
            loading: false,
        }),
    },
    DEFAULT_TRANSACTIONS
);

const DEFAULT_ACTIVE_EXPERIMENTS = {
    values: [],
    loading: true,
};

export const activeExperiments = handleActions(
    {
        [requestExperimentsDescription]: (state) => ({
            ...state,
            loading: true,
        }),
        [receiveExperimentsDescription]: (state, { payload }) => ({
            ...state,
            loading: false,
            values: payload,
        }),
    },
    DEFAULT_ACTIVE_EXPERIMENTS
);
