import React, { useEffect, useState, Component } from "react";
import { useTranslation } from "react-i18next";
import { connect, useDispatch } from "react-redux";
import _ from "lodash";
import moment from "moment";

import Loading from "@lib/components/loading";
import { formatDate } from "@lib/components/time";
import { fetchTransactions } from "src/me/actions";
import Tile from "src/me/layout/Tile";

import './index.scss';

const Transactions = connect((state) => ({
    transactions: state.transactions,
}))((props) => {
    const { uid, transactions } = props;

    const dispatch = useDispatch();
    const { t } = useTranslation("profile");

    useEffect(() => {
        dispatch(fetchTransactions(uid));
    }, [uid]);

    return <Tile title={ t("transactions") }>
        <Loading loaded={ !transactions.loading }>
        <table>
            <tr className="Transaction Transactions-Table-Header">
                <td>Время</td>
                <td>Источник</td>
                <td>Продавец</td>
                <td>Категория</td>
                <td>Бренд</td>
                <td>Описание</td>
                <td>Статус</td>
            </tr>
        {
            transactions.values
                .filter(tx => tx.Status !== "Cancelled")
                .map(tx => {
                return <tr className={ "Transaction Transaction-Source-" + tx.Source }>
                    <td className="Transaction-No-Wrap">{ moment.unix(tx.Timestamp).format("Y-MM-DD HH:mm") }</td>
                    <td className="Transaction-No-Wrap">{ tx.Source }</td>
                    <td className="Transaction-No-Wrap">{ tx.Seller || t('unknownSeller') }</td>
                    <td className="Transaction-No-Wrap">{ tx.ItemCategory }</td>
                    <td className="Transaction-No-Wrap">{ tx.ItemBrand }</td>
                    <td>{ tx.ItemDescription }</td>
                    <td className="Transaction-No-Wrap">{ tx.Status }</td>
                </tr>
            })
        }
        </table>
        </Loading>
    </Tile>;
});

export default Transactions;
