import React, { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";

import { getPublicCryptaId, getPublicCryptaIdLoading } from "./store/selectors";
import { Layout } from "./components/Layout/Layout";
import { BasicInfoSection } from "./sections/BasicInfoSection/BasicInfoSection";
import { InterestsSection } from "./sections/InterestsSection/InterestsSection";
import { TransactionsSection } from "./sections/TransactionsSection/TransactionsSection";
import { MapSection } from "./sections/MapSection/MapSection";
import { GraphSection } from "./sections/GraphSection/GraphSection";
import { NoData } from "./components/NoData/NoData";
import { fetchMyRoles, fetchPublicCryptaId } from "./store/actions";
import { getUid } from "../selectors/uid";

import "./PublicInfo.scss";

export function PublicInfo() {
    const cryptaIdLoading = useSelector(getPublicCryptaIdLoading);
    const cryptaId = useSelector(getPublicCryptaId);

    const dispatch = useDispatch();
    const uid = useSelector(getUid);

    useEffect(() => {
        dispatch(fetchMyRoles());
    }, []);

    useEffect(() => {
        if (uid) {
            dispatch(fetchPublicCryptaId(uid));
        }
    }, [uid]);

    if (!cryptaIdLoading && !cryptaId) {
        return (
            <Layout>
                <NoData/>
            </Layout>
        );
    }

    return (
        <Layout>
            <BasicInfoSection/>
            <InterestsSection/>
            <TransactionsSection/>
            <MapSection/>
            <GraphSection/>
        </Layout>
    );
}
