import React from "react";
import {
    convertAgeSegmentToText,
    convertGenderToText,
    convertHasChildrenToText,
    convertMarriedToText,
} from "../../utils/convertToText";

import "./BasicInfo.scss";

export function BasicInfo({ exactDemographics, interests, married, hasChildren, zodiac }) {
    const genderText = convertGenderToText(exactDemographics.gender).toLowerCase();
    const marriedText = convertMarriedToText(exactDemographics.gender, married);
    const ageText = convertAgeSegmentToText(exactDemographics.age);
    const hasChildrenText = convertHasChildrenToText(hasChildren);

    return (
        <div className="BasicInfo">
            Мы сделали вывод, что вы <b>{genderText}</b>
            {ageText && <>, вам <b>{ageText.toLowerCase()}</b></>}
            {marriedText && <>, вы <b>{marriedText.toLowerCase()}</b></>}
            {hasChildrenText && <>, у вас <b>{hasChildrenText.toLowerCase()}</b></>}.&nbsp;
            {zodiac && <> По гороскопу вы <b>{ zodiac }</b>.&nbsp;</>}
            Вам интересны <b>{interests.join(", ").toLowerCase()}</b>.
        </div>
    );
}

export function BasicInfoSkeleton() {
    return (
        <div className="BasicInfo BasicInfo_skeleton Skeleton"/>
    );
}
