import React, { useEffect, useState } from "react";

import {
    convertHasChildrenToText,
    convertIncomeSegmentToText,
    convertMarriedToSingleText,
} from "../../utils/convertToText";
import { getIcons } from "../../icons/interests";

import "./BasicInfoGraphics.scss";

import male from "./male.svg";
import female from "./female.svg";
import skeleton from "./skeleton.svg";

const images = {
    male,
    female,
};

export function BasicInfoGraphics({ exactDemographics, interests, married, hasChildren }) {
    const [interestIcons, setInterestIcons] = useState([]);

    useEffect(() => {
        getIcons(interests).then(icons => setInterestIcons(icons));
    }, [interests]);

    const marriedText = convertMarriedToSingleText(exactDemographics.gender, married);
    const incomeText = convertIncomeSegmentToText(exactDemographics.income);
    const hasChildrenText = convertHasChildrenToText(hasChildren);

    return (
        <div className="BasicInfoGraphics">
            <img alt="" className="BasicInfoGraphics-Image" src={images[exactDemographics.gender]}/>
            <div className="BasicInfoGraphics-Bubble BasicInfoGraphics-Bubble_family">{marriedText}</div>
            <div className="BasicInfoGraphics-Bubble BasicInfoGraphics-Bubble_income">{incomeText}</div>
            <div className="BasicInfoGraphics-Bubble BasicInfoGraphics-Bubble_children">{hasChildrenText}</div>
            <div className="BasicInfoGraphics-Interest BasicInfoGraphics-Interest_first">
                <div className="BasicInfoGraphics-InterestIcon"
                     style={{ backgroundImage: `url(${interestIcons[0]})` }}/>
            </div>
            <div className="BasicInfoGraphics-Interest BasicInfoGraphics-Interest_second">
                <div className="BasicInfoGraphics-InterestIcon"
                     style={{ backgroundImage: `url(${interestIcons[1]})` }}/>
            </div>
            <div className="BasicInfoGraphics-Interest BasicInfoGraphics-Interest_third">
                <div className="BasicInfoGraphics-InterestIcon"
                     style={{ backgroundImage: `url(${interestIcons[2]})` }}/>
            </div>
        </div>
    );
}

export function BasicInfoGraphicsSkeleton() {
    return (
        <div className="BasicInfoGraphics">
            <img alt="" className="BasicInfoGraphics-Image" src={skeleton}/>
        </div>
    );
}
