import React from 'react';
import { useSelector } from "react-redux";

import { getPublicCryptaId } from "../../store/selectors";

import "./Footer.scss";

export function Footer() {
    const cryptaId = useSelector(getPublicCryptaId);

    return (
        <footer className="PublicInfoFooter">
            { cryptaId && <div>Информация получена по ID { cryptaId }</div> }
            <div className="PublicInfoFooter-Copyright">Коммерческая тайна ООО «Яндекс», 119021, Россия, г. Москва, ул. Льва Толстого, д. 16</div>
        </footer>
    )
}
