import React from "react";

import "./Header.scss";

import logo from "./logo.svg";
import { Search } from "../Search/Search";
import { useSelector } from "react-redux";
import { getMyRoles } from "../../store/selectors";

export function Header() {
    const myRoles = useSelector(getMyRoles);
    const isAdmin = myRoles.filter(e => e.group === 'admin').length > 0;

    return (
        <header className="PublicInfoHeader">
            <img alt="" className="PublicInfoHeader-Logo" src={logo}/>
            { isAdmin && <Search/> }
        </header>
    );
}
