import React, { useEffect, useState } from "react";

import { getIcon } from "../../icons/interests";

import "./Interest.scss";

export function Interest({ name, subItems }) {
    const [icon, setIcon] = useState([]);

    useEffect(() => {
        getIcon(name).then(icon => setIcon(icon));
    }, [name]);

    return (
        <article className="Interest">
            <div className="Interest-IconWrapper">
                <div className="Interest-Icon" style={{ backgroundImage: `url(${icon})` }}/>
            </div>
            <h3 className="Interest-Name">{name}</h3>
            <ul className="Interest-SubItems">
                {subItems.map((e, i) => <li key={i} className="Interest-SubItem">{e}</li>)}
            </ul>
        </article>
    );
}

export function InterestSkeleton({ height }) {
    return (
        <article className="Interest Interest_skeleton Skeleton" style={{ height }}/>
    );
}
