import React from "react";
import { Interest, InterestSkeleton } from "../Interest/Interest";

import Masonry from "react-masonry-component";

import "./InterestsColumns.scss";

const masonryOptions = {
    gutter: 15,
    columnWidth: 260,
    fitWidth: true,
};

export function InterestsColumns({ interests }) {
    return (
        <Masonry className="InterestsColumns" options={masonryOptions}>
            {
                interests.map((e, i) => (
                    <div key={i} className="InterestsColumns-Block">
                        <Interest name={e.name} subItems={e.subItems}/>
                    </div>
                ))
            }
        </Masonry>
    );
}

export function InterestsColumnsSkeleton() {
    const blockHeights = [242, 218, 314, 218, 242, 218, 314, 218];

    return (
        <Masonry className="InterestsColumns" options={masonryOptions}>
            {
                blockHeights.map((e, i) => (
                    <div key={i} className="InterestsColumns-Block">
                        <InterestSkeleton height={e + "px"}/>
                    </div>
                ))
            }
        </Masonry>
    );
}
