import React from "react";
import { useSelector } from "react-redux";

import { getSearchObject } from "../../../selectors/router";
import { Header } from "../Header/Header";
import { Footer } from "../Footer/Footer";

import "./Layout.scss";

export function Layout({ children }) {
    const search = useSelector(getSearchObject);

    const className = "Layout" + (search.forProjector ? " Layout_for-projector" : "");

    return (
        <div className={className}>
            <Header/>
            <main>
                {children}
            </main>
            <Footer/>
        </div>
    );
}
