import React, { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { compose } from "@bem-react/core";
import { Textinput as TextinputBase, withSizeM, withViewDefault } from "@yandex-lego/components/Textinput/desktop";
import { Icon } from '@yandex-lego/components/Icon/desktop'
import { Button as ButtonBase, withSizeM as buttonWithSizeM, withViewAction } from '@yandex-lego/components/Button/desktop'
import { getUid } from "../../../selectors/uid";
import { setUid } from "../../../actions/router";
import { getPublicProfileLoading } from "../../store/selectors";

import "./Search.scss";

import icon from "./icon.svg";

const Textinput = compose(withViewDefault, withSizeM)(TextinputBase);
const Button = compose(buttonWithSizeM, withViewAction)(ButtonBase);

export function Search() {
    const loading = useSelector(getPublicProfileLoading);
    const uid = useSelector(getUid);
    const dispatch = useDispatch();
    const [value, setValue] = useState(uid);

    const onSubmit = (e) => {
        e.preventDefault();

        dispatch(setUid(value));
    };

    return (
        <form className="Search" onSubmit={onSubmit}>
            <Textinput
                className="Search-Input"
                size="m"
                view="default"
                placeholder="Введите идентификатор"
                value={value}
                iconLeft={<Icon size="m" className="Search-Icon" url={icon}/>}
                onChange={(event) => setValue(event.target.value)}
                disabled={loading}
            />
            <Button
                type="submit"
                view="action"
                size="m"
                disabled={loading}
            >
                Найти
            </Button>
        </form>
    );
}
