import React from "react";

export function Section({ id, className = "", header, description, children }) {
    return (
        <section id={id} className={"Section " + className}>
            <header className="Section-HeaderWrapper">
                <h2 className="Section-Header">{header}</h2>
                {description && <div className="Section-Description">{description}</div>}
            </header>
            <div className="Section-Body">
                {children}
            </div>
        </section>
    );
}
