import React from "react";

import { Currency } from "../Currency/Currency";

import "./TransactionCategoryList.scss";

export function TransactionCategoryList({ transactions }) {
    return (
        <ul className="TransactionCategoryList">
            {
                transactions.map((e, i) => (
                    <li key={i}>
                        <TransactionCategory name={e.name} amount={e.amount}/>
                    </li>
                ))
            }
        </ul>
    );
}

export function TransactionCategory({ name, amount }) {
    return (
        <div className="TransactionCategory">
            <div className="TransactionCategory-Name">{name}</div>
            <div className="TransactionCategory-Amount">
                <Currency amount={amount}/>
            </div>
        </div>
    );
}

export function TransactionCategoryListSkeleton() {
    const categoryWidths = [90, 70, 80, 60];

    return (
        <ul className="TransactionCategoryList">
            {
                categoryWidths.map((e, i) => (
                    <li key={i}>
                        <TransactionCategorySkeleton width={e + "%"}/>
                    </li>
                ))
            }
        </ul>
    );
}

export function TransactionCategorySkeleton({ width }) {
    return (
        <div className="TransactionCategory TransactionCategory_skeleton Skeleton" style={{ width }}/>
    );
}
