import React from "react";

import { Currency } from "../Currency/Currency";

import "./TransactionSummary.scss";

import male from "./male.svg";
import female from "./female.svg";
import skeleton from "./skeleton.svg";

const images = {
    male,
    female,
};

export function TransactionSummary({ gender, totalAmount }) {
    return (
        <div className="TransactionSummary">
            <img alt="" className="TransactionSummary-Image" src={images[gender]}/>
            <div className="TransactionSummary-Total">
                <div className="TransactionSummary-Wrapper">
                    <div className="TransactionSummary-TotalText">Куплено на сумму</div>
                    <div className="TransactionSummary-TotalAmount">
                        <Currency amount={totalAmount}/>
                    </div>
                </div>
            </div>
        </div>
    );
}

export function TransactionSummarySkeleton() {
    return (
        <div className="TransactionSummary">
            <img alt="" className="TransactionSummary-Image" src={skeleton}/>
        </div>
    );
}
