export const INTEREST_TO_ICON = {
    "Бизнес": "business.svg",
    "Бытовая техника": "appliances.svg",
    "Еда и напитки": "food.svg",
    "Животные": "animals.svg",
    "Канцтовары": "stationery.svg",
    "Красота и здоровье": "beauty.svg",
    "Недвижимость": "realty.svg",
    "Образование": "education.svg",
    "Одежда, обувь и аксессуары": "clothes.svg",
    "Отдых и путешествия": "rest.svg",
    "Подарки и цветы": "gifts.svg",
    "Работа": "job.svg",
    "Развлечения и досуг": "entertainments.svg",
    "Сельскохозяйственное оборудование и техника": "agro.svg",
    "Семья и дети": "family.svg",
    "Спорт": "sport.svg",
    "Строительство, обустройство и ремонт": "construction.svg",
    "Телеком": "telecom.svg",
    "Транспорт": "transport.svg",
    "Финансы": "finance.svg",
    "Электроника": "electronics.svg",
};

export function getIcon(interest) {
    return import("./" + INTEREST_TO_ICON[interest])
        .then(e => e.default);
}

export function getIcons(interests) {
    return Promise.all(interests.map(e => getIcon(e)));
}
