import React from "react";
import { useSelector } from "react-redux";
import { getPublicProfile, getPublicProfileLoading, getTopInterests, getZodiac } from "../../store/selectors";

import { BasicInfoGraphics, BasicInfoGraphicsSkeleton } from "../../components/BasicInfoGraphics/BasicInfoGraphics";
import { BasicInfo, BasicInfoSkeleton } from "../../components/BasicInfo/BasicInfo";

import "./BasicInfoSection.scss";

import noData from "./no-data.svg";

export function BasicInfoSection() {
    const loading = useSelector(getPublicProfileLoading);
    const profile = useSelector(getPublicProfile);
    const interests = useSelector(getTopInterests);
    const zodiac = useSelector(getZodiac);

    if (loading) {
        return (
            <section id="basic" className="BasicInfoSection">
                <BasicInfoGraphicsSkeleton/>
                <div>
                    <h2 className="BasicInfoSection-Header">Ваш профиль</h2>
                    <BasicInfoSkeleton/>
                </div>
            </section>
        );
    }

    if (!profile.exactDemographics) {
        return (
            <section id="basic" className="BasicInfoSection">
                <img alt="Нет данных" src={noData}/>
                <div>
                    <h2 className="BasicInfoSection-Header">Ваш профиль</h2>
                    <div className="BasicInfoSection-Disclaimer">
                        К сожалению, мы не смогли найти данные этого пользователя. Попробуйте ввести другой
                        идентификатор
                    </div>
                </div>
            </section>
        );
    }

    return (
        <section id="basic" className="BasicInfoSection">
            <BasicInfoGraphics
                exactDemographics={profile.exactDemographics}
                interests={interests}
                hasChildren={profile.hasChildren}
                married={profile.married}
            />
            <div>
                <h2 className="BasicInfoSection-Header">Ваш профиль</h2>
                <BasicInfo
                    exactDemographics={profile.exactDemographics}
                    interests={interests}
                    hasChildren={profile.hasChildren}
                    married={profile.married}
                    zodiac={zodiac}
                />
                <div className="BasicInfoSection-Disclaimer">
                    Данные получены на основе истории ваших действий в Интернете.
                </div>
            </div>
        </section>
    );
}
