import React from "react";
import { useSelector } from "react-redux";

import { getInterests, getPublicProfileLoading } from "../../store/selectors";

import { Section } from "../../components/Section/Section";
import { InterestsColumns, InterestsColumnsSkeleton } from "../../components/InterestsColumns/InterestsColumns";

import noData from "./no-data.svg";

export function InterestsSection() {
    const loading = useSelector(getPublicProfileLoading);
    const interests = useSelector(getInterests);

    const description = interests.length !== 0
        ? "Это вам интересно, на основе истории ваших действий в Интернете"
        : "К сожалению, мы не смогли выявить ваши интересы";

    if (loading) {
        return (
            <Section
                id="interests"
                header="Интересы"
            >
                <InterestsColumnsSkeleton/>
            </Section>
        );
    }

    return (
        <Section
            id="interests"
            header="Интересы"
            description={description}
        >
            {
                interests.length !== 0
                    ? <InterestsColumns interests={interests}/>
                    : <img alt="Нет данных" src={noData}/>
            }
        </Section>
    );
}
