import React from "react";
import { useSelector } from "react-redux";
import { YMaps } from "react-yandex-maps";

import { Section } from "../../components/Section/Section";
import { Map, MapSkeleton } from "../../components/Map/Map";
import { getPublicProfileLoading, getRegularGeo } from "../../store/selectors";

import "./MapSection.scss";

import noData from "./no-data.svg";

import home from "./home.svg";
import work from "./work.svg";
import unknown from "./unknown.svg";

const TYPE_TO_COLOR = {
    WORK: "#FF0000",
    HOME: "#FF0000",
    UNKNOWN: "#FF3333",
};

const TYPE_TO_SIZE = {
    WORK: 46,
    HOME: 46,
    UNKNOWN: 40,
};

const TYPE_TO_IMAGE = {
    WORK: work,
    HOME: home,
    UNKNOWN: unknown,
};

export function MapSection() {
    const loading = useSelector(getPublicProfileLoading);
    const regularGeo = useSelector(getRegularGeo);

    const points = regularGeo.map(e => ({
        position: [e.latitude, e.longitude],
        color: TYPE_TO_COLOR[e.type],
        size: TYPE_TO_SIZE[e.type],
        imageHref: TYPE_TO_IMAGE[e.type],
    }));

    const description = points.length === 0 ? "К сожалению, мы не смогли найти ваши любимые места" : undefined;

    if (loading) {
        return (
            <Section
                id="map"
                header="Самые посещаемые места"
            >
                <MapSkeleton/>
            </Section>
        );
    }

    return (
        <Section
            id="map"
            header="Самые посещаемые места"
            description={description}
        >
            {
                points.length !== 0
                    ? (
                        <YMaps>
                            <Map points={points}/>
                        </YMaps>
                    )
                    : <img alt="Нет данных" src={noData}/>
            }
        </Section>
    );
}
