import React from "react";
import { useSelector } from "react-redux";
import {
    getGender,
    getPublicProfileLoading,
    getPublicTransactionsLoading,
    getTransactions,
} from "../../store/selectors";

import { Section } from "../../components/Section/Section";
import { TransactionSummary, TransactionSummarySkeleton } from "../../components/TransactionSummary/TransactionSummary";
import {
    TransactionCategoryList,
    TransactionCategoryListSkeleton,
} from "../../components/TransactionCateroryList/TransactionCategoryList";

import "./TransactionsSection.scss";

import noData from "./no-data.svg";

export function TransactionsSection() {
    const profileLoading = useSelector(getPublicProfileLoading);
    const gender = useSelector(getGender);

    const transactionsLoading = useSelector(getPublicTransactionsLoading);
    const transactions = useSelector(getTransactions);

    const loading = profileLoading || transactionsLoading;

    const totalAmount = transactions.reduce((acc, e) => acc + e.amount, 0);

    const description = transactions.length !== 0
        ? "Некоторые покупки могут быть не видны. Но мы обязательно их добавим"
        : "К сожалению, мы не смогли найти ваши покупки";

    if (loading) {
        return (
            <Section
                id="transactions"
                className="TransactionsSection"
                header="Ваши покупки за последний год"
            >
                <div className="TransactionsSection-Body TransactionsSection-Body_skeleton">
                    <TransactionSummarySkeleton/>
                    <TransactionCategoryListSkeleton/>
                </div>
            </Section>
        );
    }

    return (
        <Section
            id="transactions"
            className="TransactionsSection"
            header="Ваши покупки за последний год"
            description={description}
        >
            {
                transactions.length !== 0
                    ? (
                        <div className="TransactionsSection-Body">
                            <TransactionSummary gender={gender} totalAmount={totalAmount}/>
                            <TransactionCategoryList transactions={transactions}/>
                        </div>
                    )
                    : <img alt="Нет данных" src={noData}/>
            }
        </Section>
    );
}
